


// Referenced classes of package duggelz.jape:
//            Field

class ShortField
    implements Field
{

    public ShortField(int offset)
    {
        this.offset = offset;
    }

    public String get(byte data[])
    {
        return Integer.toString(getInt(data));
    }

    public int getInt(byte data[])
    {
        int value = data[offset] & 0xff | (data[offset + 1] & 0xff) << 8;
        return value;
    }

    public void set(byte data[], String str)
        throws NumberFormatException
    {
        int value = Integer.parseInt(str);
        setInt(data, value);
    }

    public void setInt(byte data[], int value)
    {
        data[offset] = (byte)(value & 0xff);
        data[offset + 1] = (byte)(value >>> 8 & 0xff);
    }

    private int offset;
}